#pragma once

using namespace System;
using namespace System::Windows::Forms;
using namespace System::Runtime::InteropServices;
using namespace System::Drawing;
using namespace Microsoft::Win32;

namespace CGpibCLI
{

	// ************************************************** [`FbN(f)֐] **********************************
	long CheckRet(String^ Func, long Ret, String^ * sBuf)
	{
		long	RetCode;
		long	RetTmp;

		RetCode = 0;						// 펞
		RetTmp = Ret & 0xff;				// }XN
		if(RetTmp >= 3){					// Ret3ȏ̏ꍇ̓G[
			RetCode = 1;					// ُ펞
			switch(RetTmp)
			{
				case 3:		*sBuf = Func + " : FIFOɃf[^cĂ܂B"; 							break;	// 0x03
				case 80:	*sBuf = Func + " : I/OAhXG[łB[Config.exe]ŊmFĂB";	break;	// 0x50
				case 82:	*sBuf = Func + " : WXgݒG[łB[Config.exe]ŊmFĂB";	break;	// 0x52
				case 128:	*sBuf = Func + " : Meʂ𒴂SRQMĂ܂B"; 					break;	// 0x80
				case 200:	*sBuf = Func + " : Xbh쐬ł܂B"; 								break;	// 0xC8
				case 201:	*sBuf = Func + " : ̃Cxgsł"; 									break;	// 0xC9
				case 210:	*sBuf = Func + " : DMAݒł܂"; 										break;	// 0xD0
				case 240:	*sBuf = Func + " : EscL[܂B"; 									break;	// 0xF0
				case 241:	*sBuf = Func + " : t@Co̓G[łB"; 								break;	// 0xF1
				case 242:	*sBuf = Func + " : AhXw肪ԈĂ܂B"; 							break;	// 0xF2
				case 243:	*sBuf = Func + " : obt@wG[łB";									break;	// 0xF3
				case 244:	*sBuf = Func + " : zTCYG[łB";										break;	// 0xF4
				case 245:	*sBuf = Func + " : obt@܂B"; 									break;	// 0xF5
				case 246:	*sBuf = Func + " : sȃIuWFNgłB"; 								break;	// 0xF6
				case 247:	*sBuf = Func + " : foCX̉̃`FbNłB"; 						break;	// 0xF7
				case 248:	*sBuf = Func + " : sȃf[^^łB"; 										break;	// 0xF8
				case 249:	*sBuf = Func + " : ȏfoCXǉł܂B"; 						break;	// 0xF9
				case 250:	*sBuf = Func + " : foCX܂B"; 								break;	// 0xFA
				case 251:	*sBuf = Func + " : f~^foCXԂňĂ܂B"; 						break;	// 0xFB
				case 252:	*sBuf = Func + " : GPIBG[łB"; 											break;	// 0xFC
				case 253:	*sBuf = Func + " : f~^݂̂M܂B"; 								break;	// 0xFD
				case 254:	*sBuf = Func + " : ^CAEg܂B"; 									break;	// 0xFE
				case 255:	*sBuf = Func + " : p[^G[łB"; 									break;	// 0xFF
			}
		}else{
			*sBuf = Func + " : I܂B";			
		}

		// -- [Ifc] [Srq] M̏ -- //
		RetTmp = Ret & 0xff00;				// }XN
		switch(RetTmp)
		{
			case 0x100:		*sBuf = *sBuf + " -- [SRQ]M<STATUS>";			break;	// 256(10)
			case 0x200:		*sBuf = *sBuf + " -- [IFC]M<STATUS>";			break;	// 512(10)
			case 0x300:		*sBuf = *sBuf + " -- [SRQ][IFC]M<STATUS>";	break;	// 768(10)
		}
		return	RetCode;
	}
		
	//************************************************************ [ׂ֐] **********************************
	int Pows(int x, int y)
	{
		int tmp = 1;

		while (y-- > 0)													// y ̉񐔕JԂ܂B
			tmp *= x;													// tmp  x |Ă܂B
		return(tmp);
	}

	//****************************************************** [ -> 16i] **********************************
	unsigned long chr2hex(String^ ch)
	{
		long	length;
		long 	Count;
		long	Ret;
		long	RetTmp;

		RetTmp = 0;
		length	= ch->Length;											// 𒲂ׂ܂B
		for(Count=0; Count<length; Count++){							// JԂ܂B
			if((ch[Count] >= 0x30) && (ch[Count] <=0x39)){				// ASCIIR[h琔IȒl擾	
				Ret = (ch[Count] - 0x30) * Pows(0x10,(length - (Count + 1)));	// 0 - 9 
			}
			else if((ch[Count] >= 0x41) && (ch[Count] <= 0x46)){
				Ret = (ch[Count] - 0x37) * Pows(0x10,(length - (Count + 1)));	// A - F 
			}
			else if((ch[Count] >= 0x61) && (ch[Count] <= 0x66)){
				Ret = (ch[Count] - 0x57) * Pows(0x10,(length - (Count + 1)));	// a - f 
			}
			else{
				Ret = 0xff;												// sȏꍇFF(255)Ԃ܂B
			}

			RetTmp = RetTmp + Ret;
		}
		return RetTmp;
	}

	//************************************************************ [֐] **********************************
	long GpibInit(String^ * TextRet)
	{
	//	int				Delim,Eoi;
		int				Timeout, Ifctime, Ret;	
		String^			csBuf;
		unsigned long	Master;

		Ret = GpExit();													// 2dh܂B
		Ret = GpIni();													// GPIB܂B
		csBuf = "GpIni";

		if((Ret & 0xFF) != 0){											// GpIniɍs`FbNB
			CheckRet("GpIni", Ret, &csBuf);
			*TextRet = csBuf;
			return	1;
		}

		GpBoardsts(0x0a, &Master);										// }X^̃AhX擾܂B
		// }X^AX[u̔
		if(Master == 0){
			Ifctime = 1;												// ł100secɂĂ܂B
			Ret = GpIfc(Ifctime);
			csBuf = "GpIfc";
			if((Ret & 0xFF) != 0){										// GpIfcɍs`FbNB
				CheckRet("GpIfc", Ret, &csBuf);
				*TextRet = csBuf;
				return	1;
			}
			Ret = GpRen();
			csBuf = "GpRen";
			if((Ret & 0xFF) != 0){										// GpRenɍs`FbNB
				CheckRet("GpRen", Ret, &csBuf);
				*TextRet = csBuf;
				return	1;
			}
		}

		/*Delim = 1;													// f~^FCR+LF
		Eoi = 1;														// EOI     Fgp
		Ret = GpDelim(Delim, Eoi);
		csBuf = "GpDelim";
		if((Ret & 0xFF) != 0){											// GpDelimɍs`FbNB
			CheckRet("GpDelim", Ret, &csBuf);
			*TextRet = csBuf;
			return	1;
		}*/
		Timeout = 10000;												// 10b
		Ret = GpTimeout(Timeout);
		csBuf = "GpTimeout";
		if((Ret & 0xFF) != 0){											// GpTimeoutɍs`FbNB
			*TextRet = csBuf;
			CheckRet("GpTimeout", Ret, &csBuf);
			return	1;
		}

		*TextRet = "܂B";							// I
		return	0;
	}

	//******************************************************** [GpTalk()̉p] **********************************
	long GpibPrint(long DevAddr, String^ Str)
	{
		String^					srbuf = gcnew String(' ', 10000);		// M
		unsigned long			MyAddr;									// }CAhX
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(16);	// R}hp
		String^					ErrText;								// G[
		long					Ret, RetTmp, srlen;						// ߂lA\߂lA̒

		Ret = GpBoardsts(0x08, &MyAddr);								// }CAhX擾
		Cmd[0] = 2;														// R}h̐
		Cmd[1] = MyAddr;												// }CAhX(PC)
		Cmd[2] = DevAddr;												// X[u@

		srlen = Str->Length;											// 𑪒
		srbuf = Str;										
		Ret = GpTalk(Cmd, srlen, srbuf);								// ۂ̑M
		if (Ret >= 3){													// G[`FbN
			RetTmp = CheckRet("GpTalk", Ret, &ErrText);
			ErrText += " p܂H";
			if (MessageBox::Show(ErrText, Application::ProductName, MessageBoxButtons::YesNo, MessageBoxIcon::Warning) == DialogResult::No){
				return 1;												// ُ
			}
		}
		return 0;														// 
	}

	//****************************************************** [GpListen()̉p] **********************************
	long GpibInput(long DevAddr, StringBuilder^ Str)
	{
		unsigned long			MyAddr, srlen;							// }CAhXA̒
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(16);	// R}hp
		String^					ErrText;								// G[
		long					Ret, RetTmp;							// ߂lA\߂l

		Ret = GpBoardsts(0x08, &MyAddr);								// }CAhX擾
		Cmd[0] = 2;														// R}h̐
		Cmd[1] = DevAddr;												// X[u@
		Cmd[2] = MyAddr;												// }CAhX(PC)
		srlen = Str->Capacity;											// Mf[^̒𑪂Ă܂B
		Ret = GpListen(Cmd, &srlen, Str);								// ۂ̑M
		if (Ret >= 3){													// G[`FbN
			RetTmp = CheckRet("GpListen", Ret, &ErrText);
			ErrText += " p܂H";
			if (MessageBox::Show(ErrText, Application::ProductName, MessageBoxButtons::YesNo, MessageBoxIcon::Warning) == DialogResult::No){
				return 1;												// ُ = 1Ԃ
			}
		}
				
		return 0;														//  = 0Ԃ
	}

	//HIOKIǉ
	//****************************************************** [GpListen()̉p] **********************************
	long GpibInputHioki(long DevAddr, StringBuilder^ Str)
	{
		StringBuilder^			Srbuf = gcnew StringBuilder(10000);		// ̃obt@
		unsigned long			Srlen;									// ̒
		unsigned long			MyAddr;									// }CAhX
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(16);	// bZ[W(R}h)
		String^					ErrText;								// G[
		long					Ret;									// ߂l

		Ret = GpBoardsts(0x08, &MyAddr);								// }CAhX擾
		Cmd[0] = 2;														// R}h̐
		Cmd[1] = DevAddr;												// X[u@
		Cmd[2] = MyAddr;												// }CAhX(PC)

		Str->Clear();													// 
		while (true)
		{
			Srlen = 10000;												// őM
			Ret = GpListen(Cmd, &Srlen, Srbuf);
			if (Ret <= 2)
			{															// MI
				Srbuf->Remove(static_cast<int>(Srlen), Srbuf->Length - static_cast<int>(Srlen));
				Str->Append(Srbuf);
				break;
			}
			else if (Ret == 128)
			{															// Mf[^I[o[
				Srbuf->Remove(static_cast<int>(Srlen), Srbuf->Length - static_cast<int>(Srlen));
				Str->Append(Srbuf);
				Cmd[0] = 0;												// R}hoGpListen܂B
			}
			else
			{
				CheckRet("GpListen", Ret, &ErrText);
				MessageBox::Show(ErrText, Application::ProductName, MessageBoxButtons::OK, MessageBoxIcon::Warning);
				return 1;												// ُ = 1Ԃ
			}
		}
		return 0;														//  = 0Ԃ
	}

	// ************************************************* [ oCiMp֐ ] **********************************
	long GpibInputB(long DevAddr, StringBuilder^ IntData)
	{				
		StringBuilder^			szData	= gcnew StringBuilder(10000);
		unsigned long			Ret, RetTmp, MyAddr, srlen;
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(8);
		String^					ErrText = "";
		String^					szDataVal;
		int						i;

		Ret = GpDelim(0, 1);											// f~^𑊎@ƍ킹܂B
		Ret = GpBoardsts(0x08, &MyAddr);								// }CAhX擾
		Cmd[0] = 2;														// R}h̐
		Cmd[1] = DevAddr;												// X[u@
		Cmd[2] = MyAddr;												// }CAhX(PC)
		srlen = 2;														// Mf[^̒𑪂Ă܂B
		Ret = GpListen(Cmd, &srlen, szData);
		if (Ret != 128){												// rŃf[^؂Ă邽Ret=128ɂȂ܂B
			if (Ret >= 3){												// G[`FbN
				RetTmp = CheckRet("GpListen", Ret, &ErrText);
				ErrText += " p܂H";
				if (MessageBox::Show(ErrText, Application::ProductName, MessageBoxButtons::YesNo, MessageBoxIcon::Warning) == DialogResult::No){
					return 1;											// ُ = 1Ԃ
				}
			}
		}
		Cmd[0] = 0;
								
		szDataVal = szData->ToString()->Substring(1, 1);
		for (i = 0; i < szDataVal->Length; i++)
		{
			if (Char::IsDigit(szDataVal, i) == false){
				break;
			}
		}			
		szDataVal = szDataVal->Substring(0, i);
		if (i == 0){
			srlen = 0;
		}
		else{
			srlen = int::Parse(szDataVal);
		}	
		Ret = GpListen(Cmd, &srlen, szData);

		for (i = 0; i < szData->Length; i++)
		{
			if (Char::IsDigit(szData->ToString(), i) == false){
				break;
			}
		}
		szDataVal = szData->ToString()->Substring(0, i);
		if (i == 0){
			srlen = 1;
		}
		else{
			srlen = int::Parse(szDataVal) + 1;
		}
		Ret = GpListen(Cmd, &srlen, IntData);

		Ret = GpDelim(3, 1);											// f~^߂܂B
		return 0;
	}

	//****************************************************** [R}hM֐] **********************************
	long GpibCommand(long DevAddr)
	{
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(16);
		String^					ErrText;
		long					Ret, RetTmp;

		Cmd[0] = 2;
		Cmd[1] = 0x3F;
		Cmd[2] = 0x5F;

		Ret = GpComand(Cmd);

		if (Ret != 0){
			RetTmp = CheckRet("GpComand", Ret, &ErrText);
			MessageBox::Show(ErrText, Application::ProductName, MessageBoxButtons::OK, MessageBoxIcon::Warning);
			return 1;
		}
		return 0;
	}

	//**************************************************************** [I֐] ********************************
	void GpibExit()
	{
		unsigned long			Master;
		array<unsigned long>^	Cmd = gcnew array<unsigned long>(16);
		long					Ret;

		Ret = GpBoardsts(0x0a, &Master);								// }X^̃AhX擾܂B
		if(Ret == 80) return;											// ĂȂꍇɖ߂܂B
			
		if(Master == 0){												// }X^̏ꍇ
			Cmd[0] = 2;													// R}h(bZ[W)
			Cmd[1] = 0x3f;												// AX(Xi)
			Cmd[2] = 0x5f;												// Ag[N(g[J)
			Ret = GpComand(Cmd);										// R}h𑗐M܂B
		}
		Ret = GpResetren();												// @̃[g܂B
				
		Ret = GpExit();
	}

	// OPC̃`FbN ////////////////////////////////////////////////////////////////////////////////
	void WaitOPC(long Dev)
	{
		long			Ret;
		StringBuilder^	RdData = gcnew StringBuilder(10000);

		Ret = GpibPrint(Dev, "*OPC?");									// HƂĂ邩
		Ret = GpibInput(Dev, RdData);
	}

	//**************************************************** [𐔎ɕϊ] **********************************
	void Str2Num(String^ str, unsigned long str_len , array<int>^ num, unsigned long num_len)
	{
		unsigned long	i, j, cnt;
		String^			start;

		start = str;
		j = 0;
		cnt = 0;
		for (i=0; i<str_len; i++) {
			/* string to integer */
			if (str[i] == ',') {
				start = str->Substring(j, i-j);
				try{
					num[cnt] = Convert::ToInt32(start);
				}
				catch (...){
					num[cnt] = 0;
				}
				j = i + 1;
				cnt++;
				if (cnt >= num_len){
					break;
				}
			}
		}
		if (cnt >= num_len){
			try
			{
				num[cnt] = Convert::ToInt32(start);
			}
			catch (...)
			{
				num[cnt] = 0;
			}

		}
	}

	//********************************************************** [Ot`] ********************************
	// QŃOtpsN`[_CAOgpĂ܂B
	void DrawGraph(Control^ Picture, array<int>^ num, unsigned long num_len, int min, int max)
	{
		Rectangle		Rect = Picture->ClientRectangle;
		Pen^			hPen_Black;
		Pen^			hPen_Red;
		Pen^			hPen_White;
		array<Point>^	point = gcnew array<Point>(4);
		int				x_max, y_max;
		int				x_width, y_width;
		float			x_unit, y_unit;
		unsigned long	i;

		/* Initialize */
		x_max = Rect.Right;
		y_max = Rect.Bottom;
		Graphics^ g = Picture->CreateGraphics();

		hPen_Black	= gcnew Pen(Color::Black, 1);			/* Black */
		hPen_Red	= gcnew Pen(Color::Red, 1);				/* Red   */
		hPen_White	= gcnew Pen(Color::White, 1);			/* White */
		/* Draw Structure */
		SolidBrush^ whiteBrush = gcnew SolidBrush(Color::White);
		g->FillRectangle(whiteBrush, Picture->ClientRectangle);
		for (i = 0; i <= 10; i++)
		{
			g->DrawLine(hPen_Black, (x_max / 10) * i, 0, (x_max / 10) * i, y_max);
		}
		for (i = 0; i <= 10; i++)
		{
			g->DrawLine(hPen_Black, 0, (y_max / 10) * i, x_max, (y_max / 10) * i);
		}
		point[0].X = (x_max / 10) * 5 - 1;	point[0].Y = 0;
		point[1].X = (x_max / 10) * 5 + 1;	point[1].Y = 0;
		point[2].X = (x_max / 10) * 5 + 1;	point[2].Y = y_max;
		point[3].X = (x_max / 10) * 5 - 1;	point[3].Y = y_max;
		g->DrawLines(hPen_Red, point);
		point[0].X = 0;		point[0].Y = (y_max / 10) * 5 - 1;
		point[1].X = 0;		point[1].Y = (y_max / 10) * 5 + 1;
		point[2].X = x_max;	point[2].Y = (y_max / 10) * 5 + 1;
		point[3].X = x_max;	point[3].Y = (y_max / 10) * 5 - 1;
		g->DrawLines(hPen_Red, point);
		/* Draw Graph */
		x_width = (int)num_len;
		y_width = max - min;
		x_unit = (float)((float)x_max / (float)x_width);
		y_unit = (float)((float)y_max / (float)y_width);
		for (i = 0; i < (num_len - 1); i++)
		{
			g->DrawLine(hPen_Black, x_unit * i, (y_width - (num[i] - min)) * y_unit, x_unit * (i + 1), (y_width - (num[i+1] - min)) * y_unit);
		}
	}
}